/*------------------------------------------------------------------------------*
 * File Name: stats_guis.h														*
 * Creation: ML 2/27/2004 														*
 * Purpose: OriginC header file implementing Origin Statistics GUIs.			*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW						*
 *	Hong 10/26/07 v8.0734 FIX_ERROR_LOCALIZE_WITH_MACRO							*
 *	Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO					*
 *------------------------------------------------------------------------------*/
 
#ifndef _STATS_GUIS_H
#define _STATS_GUIS_H


///////////////////////////////////////////////////////////////////////////////////
///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS
//move to analysi_utils.h 	
//#define 	STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT		"Same as Input Data"
//#define		STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR	"Uniform Linear"
//#define		STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG		"Log"
///end 	CLEAN_UP_LOCALIZATION_THINGS

///Cheney 2007-5-23 QA70-9805 SPEED_UP_STATISTIC_ON_ROW
/// Hong 10/26/07 v8.0734 FIX_ERROR_LOCALIZE_WITH_MACRO
/*
#define	STR_DESC_STATIS_GUI_LABEL_SAMPLE_SIZE				"N total"
#define	STR_DESC_STATIS_GUI_LABEL_NUM_MISSING				"N missing"
#define	STR_DESC_STATIS_GUI_LABEL_MEAN						"Mean"
#define	STR_DESC_STATIS_GUI_LABEL_SD						"Standard Deviation"
#define	STR_DESC_STATIS_GUI_LABEL_SEM						"SE of mean"
#define	STR_DESC_STATIS_GUI_LABEL_LCL						"Lower 95% CI of Mean"
#define	STR_DESC_STATIS_GUI_LABEL_UCL						"Upper 95% CI of Mean"
#define	STR_DESC_STATIS_GUI_LABEL_VARIANCE					"Variance"
#define	STR_DESC_STATIS_GUI_LABEL_SKEWNESS					"Skewness"
#define	STR_DESC_STATIS_GUI_LABEL_SUM						"Sum"
#define	STR_DESC_STATIS_GUI_LABEL_KURTOSIS					"Kurtosis"
#define	STR_DESC_STATIS_GUI_LABEL_UNCORSUMSQ				"Uncorrected Sum of Squares"
#define	STR_DESC_STATIS_GUI_LABEL_CORSUMSQ					"Corrected Sum of Squares"
#define	STR_DESC_STATIS_GUI_LABEL_COV						"Coefficient of Variation"
#define	STR_DESC_STATIS_GUI_LABEL_MAD						"Mean absolute Deviation"
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_2					"SD times 2"
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_3					"SD times 3"
#define	STR_DESC_STATIS_GUI_LABEL_GEO_MEAN					"Geometric Mean"
#define	STR_DESC_STATIS_GUI_LABEL_GEO_SD					"Geometric SD"
#define	STR_DESC_STATIS_GUI_LABEL_MODE						"Mode"
#define	STR_DESC_STATIS_GUI_LABEL_WEIGHTSUM					"Sum of Weights"

#define	STR_DESC_STATIS_GUI_LABEL_MIN						"Minimum"
#define	STR_DESC_STATIS_GUI_LABEL_IMIN						"Index of Minimum"
#define	STR_DESC_STATIS_GUI_LABEL_P25						"1st Quartile (Q1)"
#define	STR_DESC_STATIS_GUI_LABEL_MEDIAN					"Median"
#define	STR_DESC_STATIS_GUI_LABEL_P75						"3rd Quartile (Q3)"
#define	STR_DESC_STATIS_GUI_LABEL_MAX						"Maximum"
#define	STR_DESC_STATIS_GUI_LABEL_IMAX						"Index of Maximum"
#define	STR_DESC_STATIS_GUI_LABEL_IQR						"Interquartile Range (Q3 - Q1)"
#define	STR_DESC_STATIS_GUI_LABEL_RANGE						"Range (Maximum - Minimum)"
#define	STR_DESC_STATIS_GUI_LABEL_USE_CUSTOM_PERCENTILES	"Custom Percentile(s)"
#define	STR_DESC_STATIS_GUI_LABEL_CUSTOM_PERCENTILES		"Percentile List"
*/
#define	STR_DESC_STATIS_GUI_LABEL_SAMPLE_SIZE				_L("N total")
#define	STR_DESC_STATIS_GUI_LABEL_NUM_MISSING				_L("N missing")
#define	STR_DESC_STATIS_GUI_LABEL_MEAN						_L("Mean")
#define	STR_DESC_STATIS_GUI_LABEL_SD						_L("Standard Deviation")
#define	STR_DESC_STATIS_GUI_LABEL_SEM						_L("SE of mean")
#define	STR_DESC_STATIS_GUI_LABEL_LCL						_L("Lower 95% CI of Mean")
#define	STR_DESC_STATIS_GUI_LABEL_UCL						_L("Upper 95% CI of Mean")
#define	STR_DESC_STATIS_GUI_LABEL_VARIANCE					_L("Variance")
#define	STR_DESC_STATIS_GUI_LABEL_SKEWNESS					_L("Skewness")
#define	STR_DESC_STATIS_GUI_LABEL_SUM						_L("Sum")
#define	STR_DESC_STATIS_GUI_LABEL_KURTOSIS					_L("Kurtosis")
#define	STR_DESC_STATIS_GUI_LABEL_UNCORSUMSQ				_L("Uncorrected Sum of Squares")
#define	STR_DESC_STATIS_GUI_LABEL_CORSUMSQ					_L("Corrected Sum of Squares")
#define	STR_DESC_STATIS_GUI_LABEL_COV						_L("Coefficient of Variation")
#define	STR_DESC_STATIS_GUI_LABEL_MAD						_L("Mean absolute Deviation")
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_2					_L("SD times 2")
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_3					_L("SD times 3")
#define	STR_DESC_STATIS_GUI_LABEL_GEO_MEAN					_L("Geometric Mean")
#define	STR_DESC_STATIS_GUI_LABEL_GEO_SD					_L("Geometric SD")
#define	STR_DESC_STATIS_GUI_LABEL_MODE						_L("Mode")
#define	STR_DESC_STATIS_GUI_LABEL_WEIGHTSUM					_L("Sum of Weights")

#define	STR_DESC_STATIS_GUI_LABEL_MIN						_L("Minimum")
#define	STR_DESC_STATIS_GUI_LABEL_IMIN						_L("Index of Minimum")
#define	STR_DESC_STATIS_GUI_LABEL_P25						_L("1st Quartile (Q1)")
#define	STR_DESC_STATIS_GUI_LABEL_MEDIAN					_L("Median")
#define	STR_DESC_STATIS_GUI_LABEL_P75						_L("3rd Quartile (Q3)")
#define	STR_DESC_STATIS_GUI_LABEL_MAX						_L("Maximum")
#define	STR_DESC_STATIS_GUI_LABEL_IMAX						_L("Index of Maximum")
#define	STR_DESC_STATIS_GUI_LABEL_IQR						_L("Interquartile Range (Q3 - Q1)")
#define	STR_DESC_STATIS_GUI_LABEL_RANGE						_L("Range (Maximum - Minimum)")
#define	STR_DESC_STATIS_GUI_LABEL_USE_CUSTOM_PERCENTILES	_L("Custom Percentile(s)")
#define	STR_DESC_STATIS_GUI_LABEL_CUSTOM_PERCENTILES		_L("Percentile List")
/// end FIX_ERROR_LOCALIZE_WITH_MACRO
///end SPEED_UP_STATISTIC_ON_ROW

//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
#define	STR_DESC_STATIS_GUI_LABEL_SAMPLE_SIZE_E				"N total"
#define	STR_DESC_STATIS_GUI_LABEL_NUM_MISSING_E				"N missing"
#define	STR_DESC_STATIS_GUI_LABEL_MEAN_E					"Mean"
#define	STR_DESC_STATIS_GUI_LABEL_SD_E						"Standard Deviation"
#define	STR_DESC_STATIS_GUI_LABEL_SEM_E						"SE of mean"
#define	STR_DESC_STATIS_GUI_LABEL_LCL_E						"Lower 95% CI of Mean"
#define	STR_DESC_STATIS_GUI_LABEL_UCL_E						"Upper 95% CI of Mean"
#define	STR_DESC_STATIS_GUI_LABEL_VARIANCE_E				"Variance"
#define	STR_DESC_STATIS_GUI_LABEL_SKEWNESS_E				"Skewness"
#define	STR_DESC_STATIS_GUI_LABEL_SUM_E						"Sum"
#define	STR_DESC_STATIS_GUI_LABEL_KURTOSIS_E				"Kurtosis"
#define	STR_DESC_STATIS_GUI_LABEL_UNCORSUMSQ_E				"Uncorrected Sum of Squares"
#define	STR_DESC_STATIS_GUI_LABEL_CORSUMSQ_E				"Corrected Sum of Squares"
#define	STR_DESC_STATIS_GUI_LABEL_COV_E						"Coefficient of Variation"
#define	STR_DESC_STATIS_GUI_LABEL_MAD_E						"Mean absolute Deviation"
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_2_E					"SD times 2"
#define	STR_DESC_STATIS_GUI_LABEL_SD_X_3_E					"SD times 3"
#define	STR_DESC_STATIS_GUI_LABEL_GEO_MEAN_E				"Geometric Mean"
#define	STR_DESC_STATIS_GUI_LABEL_GEO_SD_E					"Geometric SD"
#define	STR_DESC_STATIS_GUI_LABEL_MODE_E					"Mode"
#define	STR_DESC_STATIS_GUI_LABEL_WEIGHTSUM_E				"Sum of Weights"

#define	STR_DESC_STATIS_GUI_LABEL_MIN_E						"Minimum"
#define	STR_DESC_STATIS_GUI_LABEL_IMIN_E					"Index of Minimum"
#define	STR_DESC_STATIS_GUI_LABEL_P25_E						"1st Quartile (Q1)"
#define	STR_DESC_STATIS_GUI_LABEL_MEDIAN_E					"Median"
#define	STR_DESC_STATIS_GUI_LABEL_P75_E						"3rd Quartile (Q3)"
#define	STR_DESC_STATIS_GUI_LABEL_MAX_E						"Maximum"
#define	STR_DESC_STATIS_GUI_LABEL_IMAX_E					"Index of Maximum"
#define	STR_DESC_STATIS_GUI_LABEL_IQR_E						"Interquartile Range (Q3 - Q1)"
#define	STR_DESC_STATIS_GUI_LABEL_RANGE_E					"Range (Maximum - Minimum)"
#define	STR_DESC_STATIS_GUI_LABEL_USE_CUSTOM_PERCENTILES_E	"Custom Percentile(s)"
//#define	STR_DESC_STATIS_GUI_LABEL_CUSTOM_PERCENTILES		_L("Percentile List")
//------ End NEW_GETN_LOCALIZAED_CHECK_MACRO

//---move from FitNL.cpp
#define STR_POINTS_NUM		_L("Number of points") + " "
#define STR_MAX_INTR_NUM	_L("Maximum number of iterations")+" "
//---

///Cheney 2007-11-2 QA70-10626 ADD_REPLICA_INFO_IN_REPORT_TABLE
#define STR_NUMBER_OF_REPLICA								_L("Number of Replicas")
#define STR_REPLICATE_FROM_NTH_PARAMS						_L("Replicate From nth Parameter")
#define STR_NUM_OF_PARAMS_USED_IN_REPLICA					_L("Number of Parameters Used in Replicas")
///end ADD_REPLICA_INFO_IN_REPORT_TABLE

//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
#define STR_NUMBER_OF_REPLICA_E								"Number of Replicas"
#define STR_REPLICATE_FROM_NTH_PARAMS_E						"Replicate From nth Parameter"
#define STR_NUM_OF_PARAMS_USED_IN_REPLICA_E					"Number of Parameters Used in Replicas"
//------

//---- CPY 11/4/2007 MISSING_LOCALIZATION_IN_NLFIT_REPORT
#define STR_ANOAVA_GUI_LABEL_CTOTAL							_L("Corrected Total")
//----

#define STR_POLYNOMIAL_ORDER								_L("Polynomial Order")	///Cheney 2007-11-16 OUTPUT_POLYNOMIAL_ORDER_FOR_FIT_PLOYNOMIAL

///Cheney 2007-6-19 ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
#define	STR_LABEL_CUMULATIVE_FIT_CURVE	_L("Cumulative Fit Peak")
///end ALWAYS_FIND_XY_FROM_CUMULATIVE_FIT_CURVE_IF_PEAK_FIT
#define	STR_LABEL_BASELINE_FIT_CURVE	_L("Baseline")
#define	STR_LABEL_PEAK_FIT_CURVE		_L("Fit Peak")
#define STR_FIT_CURVE_ADD_BASELINE_WKS	"FitPeakCurves_AddBackBaseline"

/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
enum	{ANOVA_INDEXED_DATA, ANOVA_RAW_DATA};
/// end ANOVA_INPUT_DATA_TO_DATARANGE


// *** Descriptive Statistics ***
void ConstructDescStatGUITree(TreeNode &trGUI, int nOption);
BOOL DoDescStatsDialog(TreeNode &trGUI, BOOL bChangeParams);

// *** One Sample t-Test ***
/// Max 10/30/07 NOT_USED_FUNCTION
/*
TreeNode ConstructOneSampletTestGUITree(TreeNode &tr, int nOption);
BOOL DoOneSampletTestDialog(TreeNode &trGUI, BOOL bChangeParams);
*/
/// END NOT_USED_FUNCTION

void ConstructAddFitQuantitiesToCompute(TreeNode& trGUI); //CPY 6/29/04
void ConstructAddFitResultsOptionsCommon(TreeNode& trGUI, int nOption = 0); //CPY 8/31/04 ///Iris 6/11/05 nOption, support xyz data
void ConstructAddFitLROptions(TreeNode& trGUI); //CPY 9/2/04

///Arvin 12/08/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
void ConstructAddResidualAnalysisGUI(TreeNode& trGUI);
///END ADD_RESIDUAL_ANALYSIS_FOR_FITTING
void ConstructAddEllipseGUI(TreeNode& trGUI);	///Kevin 11/10/05	add for fit linear 

/// Max 10/30/07 NOT_USED_FUNCTION
/*
TreeNode ConstructTwoSampletTestGUITree(TreeNode& tr, int nOption);

TreeNode ConstructFrequencyCountGUITree(TreeNode& tr, int nOption);
*/
/// END NOT_USED_FUNCTION

/// YuI 09/26/05 ANOVA_DATA_SELECTION_GUI
//	TreeNode ConstructOneWayANOVAGUITree(TreeNode& tr, int nOption);
//	TreeNode ConstructTwoWayANOVAGUITree(TreeNode& tr, int nOption);
TreeNode ConstructOneWayANOVAGUITree(TreeNode& tr, int nOption, BOOL bRM);
TreeNode ConstructTwoWayANOVAGUITree(TreeNode& tr, int nOption, BOOL bRM);
/// end ANOVA_DATA_SELECTION_GUI

/// Max 10/30/07 NOT_USED_FUNCTION
/*
TreeNode ConstructFindXYGUITree(TreeNode& tr, int nOption);
 
TreeNode Construct2DBinningGUITree(TreeNode& tr, int nOption);

TreeNode ConstructFFTFilterGUITree(TreeNode &tr, int nOption);

TreeNode ConstructConvoluteGUITree(TreeNode &tr, int nOption);

TreeNode ConstructCorrelateGUITree(TreeNode &tr, int nOption);

TreeNode ConstructFFTGUITree(TreeNode &tr, int nOption);

TreeNode ConstructKaplanMeierGUITree(TreeNode& tr, int nOption);

TreeNode ConstructKWANOVAGUITree(TreeNode& tr, int nOption);

TreeNode ConstructOneSampleWilcoxonSignRanktestGUITree(TreeNode& tr, int nOption);

TreeNode ConstructWilcoxonMatchedPairsTestGUITree(TreeNode& tr, int nOption);

TreeNode ConstructMannWhitneyUTestGUITree(TreeNode& tr, int nOption);

TreeNode ConstructCorrelationGUITree(TreeNode& tr, int nOption);
*/
/// END NOT_USED_FUNCTION
TreeNode ConstructNormalityGUITree(TreeNode& tr, int nOption);

TreeNode ConstructROCCurveGUITree(TreeNode& tr, int nOption);

//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
///Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//void check_update_fit_output_book_sheet_GUI(TreeNode trGUI, int nFitType, bool bSetFitCurveOut = true);
///Arvin 12/25/07 MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL as cp said
//void check_update_fit_output_book_sheet_GUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL);


#ifndef _MOVE_FIT_OUTPUT_TO_OC_CLASS	//----CPY 3/27/08 NLFIT_FAILED_TO_BE_COMPILED added this to bring old code back
void check_update_fit_output_book_sheet_GUI(TreeNode& trGUI, const TreeNode& trInput, int nFitType, bool bSetFitCurveOut = true, LPCSTR lpcszSrcPageName = NULL, TreeNode& trOutput = NULL);
#endif

///end MOVE_OUTPUT_RESULTS_BRANCH_TO_LEFT_PANEL
///end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///Cheney 2007-10-31 QA70-10536-p12 IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
//move to page_utils.h
/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
////#define STR_MATFITTING_REPORTOUT_BOOK_COMBO 	STR_OUTPUT_REPORT_BOOK_COMBO
//#define STR_MATFITTING_REPORTOUT_BOOK_COMBO 	(STR_NONE + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
//// following are moved from event_utils.h from Cheney's old code
//#define STR_XYZFITTING_RESIDUALOUT_BOOK_COMBO 	(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_RESIDUALOUT_SHEET_COMBO 	(STR_NEW + STR_TOKEN_SEP)
//#define STR_XYZFITTING_FINDZOUT_BOOK_COMBO 		(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_FINDZOUT_SHEET_COMBO 	(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
/////Cheney 2007-10-15 QA70-10522-P4 CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING 
////#define STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO	(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_XYZFITTING_FITTEDCURVE_BOOK_COMBO	(STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
/////end CLEAN_CODE_AND_ADD_AUTO_FOR_OUTPUT_SETTING
//#define STR_MATFITTING_RESIDUALOUT_BOOK_COMBO	(STR_FIT_CURVE + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_MATFITTING_FINDZOUT_BOOK_COMBO		(STR_REPORT + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_MATFITTING_RESIDUALOUT_SHEET_COMBO	(STR_NEW + STR_TOKEN_SEP)
//#define STR_MATFITTING_FINDZOUT_SHEET_COMBO		(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
/////Cheney 2007-10-16 QA70-10536 CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
////#define STR_MATFITTING_REPORTOUT_SHEET_COMBO	(STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_MATFITTING_REPORTOUT_SHEET_COMBO	(STR_NEW + STR_TOKEN_SEP)
//#define STR_XYZFITTING_FITTEDCURVE_SHEET_COMBO	STR_MATFITTING_REPORTOUT_SHEET_COMBO
//#define STR_MATFITTING_FITTEDCURVE_SHEET_COMBO	STR_MATFITTING_REPORTOUT_SHEET_COMBO
//#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO	(STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)
//#define STR_MATFITTING_FITTEDCURVE_BOOK_COMBO_WITH_SOURCE(_STRSRC) 	(STR_SOURCE_BOOK + _STRSRC + STR_TOKEN_SEP + STR_AUTO + STR_TOKEN_SEP + STR_NEW + STR_TOKEN_SEP + STR_CUSTOM + STR_THREE_DOTS)	
/////end CLEAN_CODE_AND_FIX_BUG_OF_ADD_AUTO_FOR_OUTPUT_SETTING
///end IF_NO_FIT_PLOT_SHOULD_NEW_RESIDUAL_BOOK_SHEET
//-----

/// Iris 11/02/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
void ConstructFitXDataBranch(TreeNode& trParent);
///end OP_DLG_NEW_STRUCTURE

///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////
#endif // _STATS_GUIS_H


 
 
 
 
 
